#ifndef _DIALOGS_TABGENERAL_CPP
#define _DIALOGS_TABGENERAL_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabGeneralDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND CompanyName_hWnd     = NULL;
    static HWND CompanyPwd_hWnd      = NULL;
    static HWND ConnectInterval_hWnd = NULL;
    static HWND ServerAddress_hWnd   = NULL;
    static HWND ServerPort_hWnd      = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        CompanyName_hWnd     = GetDlgItem(xHandle, IDC_COMPANYNAME);
        CompanyPwd_hWnd      = GetDlgItem(xHandle, IDC_COMPANYPWD);

        ConnectInterval_hWnd = GetDlgItem(xHandle, IDC_CONNECTINTERVAL);
        ServerAddress_hWnd   = GetDlgItem(xHandle, IDC_SERVERADDRESS);
        ServerPort_hWnd      = GetDlgItem(xHandle, IDC_SERVERPORT);

        Set_Text(CompanyName_hWnd, gsCompanyName);
        Set_Text(CompanyPwd_hWnd, gsCompanyPassword);

        Set_Long(ConnectInterval_hWnd, gdwConnectInterval);
        Set_Text(ServerAddress_hWnd, gsServerAddress);
        Set_Long(ServerPort_hWnd, giServerPort);

        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsCompanyName[64 + 1];
            int liCompanyNameLen = Get_TextEx(CompanyName_hWnd, lsCompanyName, 64);
            if(liCompanyNameLen == 0 || liCompanyNameLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company name. Between 1 and 64 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsCompanyPwd[64 + 1];
            int liCompanyPwdLen = Get_TextEx(CompanyPwd_hWnd, lsCompanyPwd, 64);
            if(liCompanyPwdLen == 0 || liCompanyPwdLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company password. Between 1 and 64 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            DWORD ldwConnectInterval = Get_Long(ConnectInterval_hWnd);
            if(ldwConnectInterval < 5 || ldwConnectInterval > 86400)
            {
                MessageBox(xHandle, "You must enter a valid connection interval. Between 5 and 86,400.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsServerAddress[255 + 1];
            int liServerAddressLen = Get_TextEx(ServerAddress_hWnd, lsServerAddress, 255);
            if(liServerAddressLen == 0 || liServerAddressLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid server address. Between 1 and 255 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            int liServerPort = Get_Long(ServerPort_hWnd);
            if(liServerPort == 0 || liServerPort > 65535)
            {
                MessageBox(xHandle, "You must enter a valid server port. Between 1 and 65,535.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy(gsCompanyName, lsCompanyName);
            strcpy(gsCompanyPassword, lsCompanyPwd);
            strcpy(gsServerAddress, lsServerAddress);

            giServerPort       = liServerPort;
            gdwConnectInterval = ldwConnectInterval;

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
